function [SE,SP,PR,se,sp,pr,tp,fp,tn,fn] = confmat2SeSpPr(CM,verbose)

% Calcola la sensibilit e la specificit di classificazione nelle C classi 
% dove C  la dimensione della matrice di confusione CM (CxC). Le righe si
% riferiscono all'uscita del classificatore, le colonne alla classe reale
% di appartenenza dei dati
% 
% Inputs:
% CM matrice di confusione
% verbose stampa output se diverso da zero (default = 0)
% 
% Outputs:
% SE sensibilit globale (aka Recall)
% SP specificit globale
% PR precision globale
% se sensibilit classificazione singola classe (aka recall)
% sp specificit classificazione singola classe
% pr precision classificazione singola classe
% tp,tn,fp,fn veri positivi, veri negativi, falsi positivi e falsi negativi
%               per la singola classe
% 
% [Andrea Mannini: a.mannini@sssup.it; Last modified: Mar 10 2011]
% 
% Extract the sensitivity and specificity for classification into classes
% C where C is the size of the confusion matrix CM (CXC). The lines
% refers to the output of the classifier, the columns to the actual class
% membership
% 
% Upper case = global values;
% Lower case = class specific values.


if nargin<2
    verbose =0;
end

[C C1] = size (CM);

for c = 1:C
    Cm = CM;
    tmp1 = Cm(c,:);
    Cm(c,:) = [];
    tmp2 = Cm(:,c);
    Cm(:,c) = [];
    
    tp(c) = tmp1(c);
    tmp1(c) = [];
    
    fn(c) = sum(tmp1);
    fp(c) = sum(tmp2);
    tn(c) = sum(sum(Cm));
    
    se(c) = tp(c) / (tp(c) + fn(c));
    sp(c) = tn(c) / (tn(c) + fp(c));
    pr(c) = tp(c) / (tp(c) + fp(c)); 
end

SE = sum(tp) / (sum(tp) + sum(fn));
SP = sum(tn) / (sum(tn) + sum(fp));
PR = sum(tp) / (sum(tp) + sum(fp));

if verbose
    disp(['Overall Specificity (True Negative Rate) = ' num2str(SP*100) '%']);
    disp(['Overall Sensitivity (Recall) = ' num2str(SE*100) '%']);
    disp(['Overall Precision = ' num2str(PR*100) '%']);
end